require ("scripts/style.lua");

TitleFont = {
	standardFont,
	32,
	Color(0,0,255,255)
};

HeaderFont = {
	standardFont,
	24,
	Color(0,0,255,255)
};


HeaderStyle = {
	parent = DefaultStyle,
	font = HeaderFont,
	w = kMax,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

DescripFont = {
	standardFont,
	18,
	BorderColor
};

MPDescripFont = {
	standardFont,
	22,
	BlackColor
};
	
DescripStyle = {
	parent = DefaultStyle,
	font = DescripFont,
	w = 170,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

MakeDialog
{
	Bitmap
	{
		name="backgroundimage",
		image="backgrounds/fullscreendialog",
		x=0, y=0, w=kMax, h=kMax,
		
		Text
		{
			font = TitleFont,
			x=0,y=30,w=kMax,h=80,
			flags = kHAlignCenter + kVAlignTop,
			label = "mp_howtoplay"
		};
		
		SetStyle(DefaultStyle);
		
		Text
		{
			font = MPDescripFont,
			x=50,y=75,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_1"
		};
		Text
		{
			font = HeaderFont,
			x=75,y=115,w=400,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_2"
		};
		Text
		{
			font = DescripFont,
			x=75,y=140,w=400,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_3"
		};
		Text
		{
			font = HeaderFont,
			x=150,y=177,w=400,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_4"
		};
		Text
		{
			font = DescripFont,
			x=150,y=203,w=400,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_5"
		};
		
		Bitmap
		{
			image = "multi/help_joingame",
			x = 150,
			y = 225
		};
		
		Text
		{
			font = HeaderFont,
			x=150,y=339,w=400,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_6"
		};
		Text
		{
			font = DescripFont,
			x=150,y=360,w=400,h=50,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help3_7"
		};
		
		Bitmap
		{
			image = "multi/help_hostgame",
			x = 150,
			y = 400
		};

		SetStyle(SmallestButtonStyle);
		Button
		{
			x=kCenter,
			y=540,
			name="back",
			label="back",
			command=
				function()
					ActivateHelpClock(false);
					PopModal("scripts/multiplayer/help3.lua");
				end
		},
		SetStyle(HelpArrowStyle);
		
		
		Button
		{
			x=45,
			y=530,
			name="right",
			command=
				function()
					SwapToModalSetName("scripts/multiplayer/help2.lua");
				end
		},
	},
};

ActivateHelpClock(true);